import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState, useRef, useEffect } from 'react';
import { useForm } from 'react-hook-form';
import { selectors } from '@grafana/e2e-selectors';
import '../../themes/index.mjs';
import { t } from '../../utils/i18n.mjs';
import '../Button/index.mjs';
import { Field } from '../Forms/Field.mjs';
import { Input } from '../Input/Input.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Button } from '../Button/Button.mjs';

"use strict";
const ConfirmContent = ({
  body,
  confirmPromptText,
  confirmButtonLabel,
  confirmButtonVariant,
  dismissButtonVariant,
  dismissButtonLabel,
  onConfirm,
  onDismiss,
  onAlternative,
  alternativeButtonLabel,
  description,
  justifyButtons = "flex-end",
  disabled
}) => {
  const [isDisabled, setIsDisabled] = useState(disabled);
  const styles = useStyles2(getStyles);
  const buttonRef = useRef(null);
  const onConfirmationTextChange = (event) => {
    setIsDisabled((confirmPromptText == null ? void 0 : confirmPromptText.toLowerCase().localeCompare(event.currentTarget.value.toLowerCase())) !== 0);
  };
  useEffect(() => {
    var _a;
    (_a = buttonRef.current) == null ? void 0 : _a.focus();
  }, []);
  useEffect(() => {
    setIsDisabled(disabled ? true : Boolean(confirmPromptText));
  }, [confirmPromptText, disabled]);
  const onConfirmClick = async () => {
    if (disabled === void 0) {
      setIsDisabled(true);
    }
    try {
      await onConfirm();
    } finally {
      if (disabled === void 0) {
        setIsDisabled(false);
      }
    }
  };
  const { handleSubmit } = useForm();
  const placeholder = t("grafana-ui.confirm-content.placeholder", 'Type "{{confirmPromptText}}" to confirm', {
    confirmPromptText
  });
  return /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit(onConfirmClick), children: [
    /* @__PURE__ */ jsxs("div", { className: styles.text, children: [
      body,
      description ? /* @__PURE__ */ jsx("div", { className: styles.description, children: description }) : null,
      confirmPromptText ? /* @__PURE__ */ jsx("div", { className: styles.confirmationInput, children: /* @__PURE__ */ jsx(Stack, { alignItems: "flex-start", children: /* @__PURE__ */ jsx(Field, { disabled, children: /* @__PURE__ */ jsx(Input, { placeholder, onChange: onConfirmationTextChange }) }) }) }) : null
    ] }),
    /* @__PURE__ */ jsx("div", { className: styles.buttonsContainer, children: /* @__PURE__ */ jsxs(Stack, { justifyContent: justifyButtons, gap: 2, wrap: "wrap", children: [
      /* @__PURE__ */ jsx(Button, { variant: dismissButtonVariant, onClick: onDismiss, fill: "outline", children: dismissButtonLabel }),
      /* @__PURE__ */ jsx(
        Button,
        {
          type: "submit",
          variant: confirmButtonVariant,
          disabled: isDisabled,
          ref: buttonRef,
          "data-testid": selectors.pages.ConfirmModal.delete,
          children: confirmButtonLabel
        }
      ),
      onAlternative ? /* @__PURE__ */ jsx(Button, { variant: "primary", onClick: onAlternative, children: alternativeButtonLabel }) : null
    ] }) })
  ] });
};
const getStyles = (theme) => ({
  text: css({
    fontSize: theme.typography.h5.fontSize,
    color: theme.colors.text.primary
  }),
  description: css({
    fontSize: theme.typography.body.fontSize
  }),
  confirmationInput: css({
    paddingTop: theme.spacing(1)
  }),
  buttonsContainer: css({
    paddingTop: theme.spacing(3)
  })
});

export { ConfirmContent };
//# sourceMappingURL=ConfirmContent.mjs.map
