import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import * as React from 'react';
import { useRef } from 'react';
import { CSSTransition } from 'react-transition-group';
import '../../themes/index.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

"use strict";
function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = useStyles2(getStyles, duration);
  const transitionRef = useRef(null);
  return /* @__PURE__ */ jsx(
    CSSTransition,
    {
      in: visible,
      mountOnEnter: true,
      unmountOnExit: true,
      timeout: duration,
      classNames: styles,
      nodeRef: transitionRef,
      children: React.cloneElement(children, { ref: transitionRef })
    }
  );
}
const getStyles = (theme, duration) => ({
  enter: css({
    label: "enter",
    opacity: 0
  }),
  enterActive: css({
    label: "enterActive",
    opacity: 1,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  }),
  exit: css({
    label: "exit",
    opacity: 1
  }),
  exitActive: css({
    label: "exitActive",
    opacity: 0,
    [theme.transitions.handleMotion("no-preference", "reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  })
});

export { FadeTransition };
//# sourceMappingURL=FadeTransition.mjs.map
