import { jsx } from 'react/jsx-runtime';
import { startCase } from 'lodash';
import { useCallback } from 'react';
import { FilterPill } from '../../components/FilterPill/FilterPill.mjs';
import { Stack } from '../../components/Layout/Stack/Stack.mjs';

"use strict";
const SeriesConfigEditor = ({ value, onChange }) => {
  const onChangeToggle = useCallback(
    (prop) => {
      onChange({ ...value, [prop]: !value[prop] });
    },
    [value, onChange]
  );
  return /* @__PURE__ */ jsx(Stack, { gap: 0.5, children: Object.keys(value).map((k) => {
    const key = k;
    return /* @__PURE__ */ jsx(
      FilterPill,
      {
        icon: value[key] ? "eye-slash" : "eye",
        onClick: () => onChangeToggle(key),
        label: startCase(key),
        selected: value[key]
      },
      key
    );
  }) });
};
function addHideFrom(builder) {
  builder.addCustomEditor({
    id: "hideFrom",
    name: "Hide in area",
    category: ["Series"],
    path: "hideFrom",
    defaultValue: {
      tooltip: false,
      viz: false,
      legend: false
    },
    editor: SeriesConfigEditor,
    override: SeriesConfigEditor,
    shouldApply: () => true,
    hideFromDefaults: true,
    process: (value) => value
  });
}

export { addHideFrom };
//# sourceMappingURL=hideSeries.mjs.map
