import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useStyles2, Card, Button } from '@grafana/ui';
import { promqlGrammar } from '../promql.mjs';
import { promQueryModeller } from './PromQueryModeller.mjs';
import { RawQuery } from './shared/RawQuery.mjs';

"use strict";
const QueryPattern = (props) => {
  const { pattern, onPatternSelect, hasNewQueryOption, hasPreviousQuery, selectedPatternName, setSelectedPatternName } = props;
  const styles = useStyles2(getStyles);
  const lang = { grammar: promqlGrammar, name: "promql" };
  return /* @__PURE__ */ jsxs(Card, { className: styles.card, children: [
    /* @__PURE__ */ jsx(Card.Heading, { children: pattern.name }),
    /* @__PURE__ */ jsx("div", { className: styles.rawQueryContainer, children: /* @__PURE__ */ jsx(
      RawQuery,
      {
        "aria-label": `${pattern.name} raw query`,
        query: promQueryModeller.renderQuery({
          labels: [],
          operations: pattern.operations,
          binaryQueries: pattern.binaryQueries
        }),
        lang,
        className: styles.rawQuery
      }
    ) }),
    /* @__PURE__ */ jsx(Card.Actions, { children: selectedPatternName !== pattern.name ? /* @__PURE__ */ jsx(
      Button,
      {
        size: "sm",
        "aria-label": "use this query button",
        onClick: () => {
          if (hasPreviousQuery) {
            setSelectedPatternName(pattern.name);
          } else {
            onPatternSelect(pattern);
          }
        },
        children: "Use this query"
      }
    ) : /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx("div", { className: styles.spacing, children: `If you would like to use this query, ${hasNewQueryOption ? "you can either apply this query pattern or create a new query" : "this query pattern will be applied to your current query"}.` }),
      /* @__PURE__ */ jsx(Button, { size: "sm", "aria-label": "back button", fill: "outline", onClick: () => setSelectedPatternName(null), children: "Back" }),
      /* @__PURE__ */ jsx(
        Button,
        {
          size: "sm",
          "aria-label": "apply query starter button",
          onClick: () => {
            onPatternSelect(pattern);
          },
          children: "Apply query"
        }
      ),
      hasNewQueryOption && /* @__PURE__ */ jsx(
        Button,
        {
          size: "sm",
          "aria-label": "create new query button",
          onClick: () => {
            onPatternSelect(pattern, true);
          },
          children: "Create new query"
        }
      )
    ] }) })
  ] });
};
const getStyles = (theme) => {
  return {
    card: css({
      width: "49.5%",
      display: "flex",
      flexDirection: "column"
    }),
    rawQueryContainer: css({
      flexGrow: 1
    }),
    rawQuery: css({
      backgroundColor: theme.colors.background.primary,
      padding: theme.spacing(1),
      marginTop: theme.spacing(1)
    }),
    spacing: css({
      marginBottom: theme.spacing(1)
    })
  };
};

export { QueryPattern };
//# sourceMappingURL=QueryPattern.mjs.map
