import { createBreakpoints } from './breakpoints.mjs';
import { createColors } from './createColors.mjs';
import { createComponents } from './createComponents.mjs';
import { createShadows } from './createShadows.mjs';
import { createShape } from './createShape.mjs';
import { createSpacing } from './createSpacing.mjs';
import { createTransitions } from './createTransitions.mjs';
import { createTypography } from './createTypography.mjs';
import { createV1Theme } from './createV1Theme.mjs';
import { createVisualizationColors } from './createVisualizationColors.mjs';
import { zIndex } from './zIndex.mjs';

"use strict";
function createTheme(options = {}) {
  const {
    name,
    colors: colorsInput = {},
    spacing: spacingInput = {},
    shape: shapeInput = {},
    typography: typographyInput = {}
  } = options;
  const colors = createColors(colorsInput);
  const breakpoints = createBreakpoints();
  const spacing = createSpacing(spacingInput);
  const shape = createShape(shapeInput);
  const typography = createTypography(colors, typographyInput);
  const shadows = createShadows(colors);
  const transitions = createTransitions();
  const components = createComponents(colors, shadows);
  const visualization = createVisualizationColors(colors);
  const theme = {
    name: name != null ? name : colors.mode === "dark" ? "Dark" : "Light",
    isDark: colors.mode === "dark",
    isLight: colors.mode === "light",
    colors,
    breakpoints,
    spacing,
    shape,
    components,
    typography,
    shadows,
    transitions,
    visualization,
    zIndex: {
      ...zIndex
    },
    flags: {}
  };
  return {
    ...theme,
    v1: createV1Theme(theme)
  };
}

export { createTheme };
//# sourceMappingURL=createTheme.mjs.map
