import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import WKT from 'ol/format/WKT';
import { Geometry } from 'ol/geom';
import '../../../../themes/index.mjs';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';

"use strict";
function GeoCell({ value, justifyContent, height }) {
  const styles = useStyles2(getStyles);
  let disp = "";
  if (value instanceof Geometry) {
    disp = new WKT().writeGeometry(value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (value != null) {
    disp = `${value}`;
  }
  return /* @__PURE__ */ jsx("div", { className: styles.cell, style: { justifyContent, height }, children: /* @__PURE__ */ jsx("div", { className: styles.cellText, style: { fontFamily: "monospace" }, children: disp }) });
}
const getStyles = () => ({
  cell: css({
    height: "100%",
    display: "flex",
    alignItems: "center",
    padding: "0 8px"
  }),
  cellText: css({
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis"
  })
});

export { GeoCell };
//# sourceMappingURL=GeoCell.mjs.map
