import { jsx } from 'react/jsx-runtime';
import { keyframes } from '@emotion/css';

"use strict";
const fadeIn = keyframes({
  "0%": {
    opacity: 0
  },
  "100%": {
    opacity: 1
  }
});
const skeletonAnimation = {
  animationName: fadeIn,
  animationDelay: "100ms",
  animationTimingFunction: "ease-in",
  animationDuration: "100ms",
  animationFillMode: "backwards"
};
const attachSkeleton = (Component, Skeleton) => {
  const skeletonWrapper = (props) => {
    return /* @__PURE__ */ jsx(
      Skeleton,
      {
        ...props,
        rootProps: {
          style: skeletonAnimation
        }
      }
    );
  };
  return Object.assign(Component, { Skeleton: skeletonWrapper });
};

export { attachSkeleton, skeletonAnimation };
//# sourceMappingURL=skeleton.mjs.map
