import { jsx, jsxs } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { cloneElement } from 'react';
import '../../themes/index.mjs';
import { getChildId } from '../../utils/reactUtils.mjs';
import { FieldValidationMessage } from './FieldValidationMessage.mjs';
import { InlineLabel } from './InlineLabel.mjs';
import { useTheme2 } from '../../themes/ThemeContext.mjs';

"use strict";
const InlineField = ({
  children,
  label,
  tooltip,
  labelWidth = "auto",
  invalid,
  loading,
  disabled,
  required,
  className,
  htmlFor,
  grow,
  shrink,
  error,
  transparent,
  interactive,
  validationMessageHorizontalOverflow,
  ...htmlProps
}) => {
  const theme = useTheme2();
  const styles = getStyles(theme, grow, shrink);
  const inputId = htmlFor != null ? htmlFor : getChildId(children);
  const labelElement = typeof label === "string" ? /* @__PURE__ */ jsx(
    InlineLabel,
    {
      interactive,
      width: labelWidth,
      tooltip,
      htmlFor: inputId,
      transparent,
      children: `${label}${required ? " *" : ""}`
    }
  ) : label;
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.container, className), ...htmlProps, children: [
    labelElement,
    /* @__PURE__ */ jsxs("div", { className: styles.childContainer, children: [
      cloneElement(children, { invalid, disabled, loading }),
      invalid && error && /* @__PURE__ */ jsx(
        "div",
        {
          className: cx(styles.fieldValidationWrapper, {
            [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
          }),
          children: /* @__PURE__ */ jsx(FieldValidationMessage, { children: error })
        }
      )
    ] })
  ] });
};
InlineField.displayName = "InlineField";
const getStyles = (theme, grow, shrink) => {
  return {
    container: css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`,
      margin: `0 ${theme.spacing(0.5)} ${theme.spacing(0.5)} 0`
    }),
    childContainer: css({
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`
    }),
    fieldValidationWrapper: css({
      marginTop: theme.spacing(0.5)
    }),
    validationMessageHorizontalOverflow: css({
      width: 0,
      overflowX: "visible",
      "& > *": {
        whiteSpace: "nowrap"
      }
    })
  };
};

export { InlineField };
//# sourceMappingURL=InlineField.mjs.map
