import * as React from 'react';

function getChildId(children) {
  let inputId;
  const child = React.Children.only(children);
  if ("id" in (child == null ? undefined : child.props)) {
    inputId = child.props.id;
  } else if ("inputId" in child.props) {
    inputId = child == null ? undefined : child.props.inputId;
  }
  return typeof inputId === "string" ? inputId : undefined;
}
function renderOrCallToRender(itemToRender, props) {
  if (React.isValidElement(itemToRender) || typeof itemToRender === "string" || typeof itemToRender === "number") {
    return itemToRender;
  }
  if (typeof itemToRender === "function" && props) {
    return itemToRender(props);
  }
  throw new Error(`${itemToRender} is not a React element nor a function that returns React element`);
}

export { getChildId, renderOrCallToRender };
//# sourceMappingURL=reactUtils.mjs.map
