import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { sharedInputStyle, getFocusStyle } from '../Forms/commonStyles.mjs';

const TextArea = forwardRef(({ invalid, className, ...props }, ref) => {
  const styles = useStyles2(getTextAreaStyle, invalid);
  return /* @__PURE__ */ jsx("textarea", { ...props, className: cx(styles.textarea, className), ref });
});
const getTextAreaStyle = (theme, invalid = false) => ({
  textarea: cx(
    sharedInputStyle(theme),
    getFocusStyle(theme),
    css({
      display: "block",
      borderRadius: theme.shape.radius.default,
      padding: `${theme.spacing.gridSize / 4}px ${theme.spacing.gridSize}px`,
      width: "100%",
      borderColor: invalid ? theme.colors.error.border : theme.components.input.borderColor
    })
  )
});
TextArea.displayName = "TextArea";

export { TextArea };
//# sourceMappingURL=TextArea.mjs.map
