import { jsxs, jsx } from 'react/jsx-runtime';
import { Trans } from '../../../utils/i18n.mjs';
import { Button } from '../../Button/Button.mjs';
import '../../Button/ButtonGroup.mjs';
import { Stack } from '../../Layout/Stack/Stack.mjs';

function Footer({ onClose, onApply }) {
  return /* @__PURE__ */ jsxs(Stack, { gap: 2, justifyContent: "space-between", children: [
    /* @__PURE__ */ jsx(Button, { variant: "secondary", onClick: onClose, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "time-picker.calendar.cancel-button", children: "Cancel" }) }),
    /* @__PURE__ */ jsx(Button, { onClick: onApply, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "time-picker.calendar.apply-button", children: "Apply time range" }) })
  ] });
}
Footer.displayName = "Footer";

export { Footer };
//# sourceMappingURL=CalendarFooter.mjs.map
