import uFuzzy from '@leeoniya/ufuzzy';

const REGEXP_NON_ASCII = /[^ -~]/m;
const REGEXP_ONLY_SYMBOLS = /^[\x21-\x2F\x3A-\x40\x5B-\x60\x7B-\x7E]+$/m;
const outOfOrderLimit = 5;
const maxNeedleLength = 25;
const maxFuzzyTerms = 5;
const rankThreshold = 1e4;
const uf = new uFuzzy({ intraMode: 1 });
function itemToString(item) {
  var _a;
  if (item == null) {
    return "";
  }
  return (_a = item.label) != null ? _a : item.value.toString();
}
function fuzzyFind(options, haystack, needle) {
  let matches = [];
  if (needle === "") {
    matches = options;
  } else if (
    // contains non-ascii
    REGEXP_NON_ASCII.test(needle) || // is only ascii symbols (operators)
    REGEXP_ONLY_SYMBOLS.test(needle) || // too long (often copy-paste from somewhere)
    needle.length > maxNeedleLength || uf.split(needle).length > maxFuzzyTerms
  ) {
    for (let i = 0; i < haystack.length; i++) {
      let item = haystack[i];
      if (item.includes(needle)) {
        matches.push(options[i]);
      }
    }
  } else {
    const [idxs, info, order] = uf.search(haystack, needle, outOfOrderLimit, rankThreshold);
    if (idxs == null ? undefined : idxs.length) {
      if (info && order) {
        matches = order.map((idx) => options[info.idx[idx]]);
      } else {
        matches = idxs.map((idx) => options[idx]);
      }
    }
  }
  return matches;
}

export { fuzzyFind, itemToString };
//# sourceMappingURL=filter.mjs.map
