import { createContext, useContext } from 'react';
import { useObservable } from 'react-use';
import { Observable } from 'rxjs';

const ScopesContext = createContext(undefined);
function useScopes() {
  var _a;
  const context = useContext(ScopesContext);
  useObservable((_a = context == null ? undefined : context.stateObservable) != null ? _a : new Observable(), context == null ? undefined : context.state);
  return context ? {
    state: context.state,
    stateObservable: context.stateObservable,
    changeScopes: context.changeScopes,
    setReadOnly: context.setReadOnly,
    setEnabled: context.setEnabled
  } : undefined;
}

export { ScopesContext, useScopes };
//# sourceMappingURL=ScopesContext.mjs.map
