import { jsx } from 'react/jsx-runtime';
import { EditorRow, EditorFieldGroup } from '@grafana/plugin-ui';
import { promqlGrammar } from '../../promql.mjs';
import { RawQuery } from '../shared/RawQuery.mjs';

function QueryPreview({ query }) {
  if (!query) {
    return null;
  }
  return /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(EditorFieldGroup, { children: /* @__PURE__ */ jsx(RawQuery, { query, lang: { grammar: promqlGrammar, name: "promql" } }) }) });
}

export { QueryPreview };
//# sourceMappingURL=QueryPreview.mjs.map
