import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { omit } from 'lodash';
import { Trans } from '../../utils/i18n.mjs';
import { Button } from '../Button/Button.mjs';
import { FormField } from '../FormField/FormField.mjs';

const getSecretFormFieldStyles = () => {
  return {
    noRadiusInput: css({
      borderBottomRightRadius: "0 !important",
      borderTopRightRadius: "0 !important"
    }),
    noRadiusButton: css({
      borderBottomLeftRadius: "0 !important",
      borderTopLeftRadius: "0 !important"
    })
  };
};
const SecretFormField = ({
  label = "Password",
  labelWidth,
  inputWidth = 12,
  onReset,
  isConfigured,
  tooltip,
  placeholder = "Password",
  interactive,
  ...inputProps
}) => {
  const styles = getSecretFormFieldStyles();
  return /* @__PURE__ */ jsx(
    FormField,
    {
      label,
      tooltip,
      interactive,
      labelWidth,
      inputEl: isConfigured ? /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx(
          "input",
          {
            type: "text",
            className: cx(`gf-form-input width-${inputWidth}`, styles.noRadiusInput),
            disabled: true,
            value: "configured",
            ...omit(inputProps, "value")
          }
        ),
        /* @__PURE__ */ jsx(Button, { onClick: onReset, variant: "secondary", type: "button", children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.secret-form-field.reset", children: "Reset" }) })
      ] }) : /* @__PURE__ */ jsx(
        "input",
        {
          type: "password",
          className: `gf-form-input width-${inputWidth}`,
          placeholder,
          ...inputProps
        }
      )
    }
  );
};
SecretFormField.displayName = "SecretFormField";

export { SecretFormField };
//# sourceMappingURL=SecretFormField.mjs.map
