import { jsx, jsxs } from 'react/jsx-runtime';

function fontSizeReductionFactor(fontSize) {
  if (fontSize < 20) {
    return 0.9;
  }
  if (fontSize < 26) {
    return 0.8;
  }
  return 0.6;
}
const FormattedValueDisplay = ({ value, className, style, ...htmlProps }) => {
  var _a, _b;
  const hasPrefix = ((_a = value.prefix) != null ? _a : "").length > 0;
  const hasSuffix = ((_b = value.suffix) != null ? _b : "").length > 0;
  let suffixStyle;
  if (style && typeof style.fontSize === "number" && !Number.isNaN(style.fontSize)) {
    const fontSize = style.fontSize;
    const reductionFactor = fontSizeReductionFactor(fontSize);
    suffixStyle = { fontSize: fontSize * reductionFactor };
  }
  return /* @__PURE__ */ jsx("div", { className, style, ...htmlProps, children: /* @__PURE__ */ jsxs("div", { children: [
    hasPrefix && /* @__PURE__ */ jsx("span", { children: value.prefix }),
    /* @__PURE__ */ jsx("span", { children: value.text }),
    hasSuffix && /* @__PURE__ */ jsx("span", { style: suffixStyle, children: value.suffix })
  ] }) });
};
FormattedValueDisplay.displayName = "FormattedDisplayValue";

export { FormattedValueDisplay };
//# sourceMappingURL=FormattedValueDisplay.mjs.map
