import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { ConfigSubSection } from '@grafana/plugin-ui';
import { useTheme2, Button } from '@grafana/ui';
import { overhaulStyles } from './ConfigEditor.mjs';
import { ExemplarSetting } from './ExemplarSetting.mjs';

function ExemplarsSettings({ options, onChange, disabled }) {
  const theme = useTheme2();
  const styles = overhaulStyles(theme);
  return /* @__PURE__ */ jsx("div", { className: styles.sectionBottomPadding, children: /* @__PURE__ */ jsxs(ConfigSubSection, { title: "Exemplars", className: styles.container, children: [
    options && options.map((option, index) => {
      return /* @__PURE__ */ jsx(
        ExemplarSetting,
        {
          value: option,
          onChange: (newField) => {
            const newOptions = [...options];
            newOptions.splice(index, 1, newField);
            onChange(newOptions);
          },
          onDelete: () => {
            const newOptions = [...options];
            newOptions.splice(index, 1);
            onChange(newOptions);
          },
          disabled
        },
        index
      );
    }),
    !disabled && /* @__PURE__ */ jsx(
      Button,
      {
        variant: "secondary",
        "data-testid": selectors.components.DataSource.Prometheus.configPage.exemplarsAddButton,
        className: css({
          marginBottom: "10px"
        }),
        icon: "plus",
        onClick: (event) => {
          event.preventDefault();
          const newOptions = [...options || [], { name: "traceID" }];
          onChange(newOptions);
        },
        children: "Add"
      }
    ),
    disabled && !options && /* @__PURE__ */ jsx("i", { children: "No exemplars configurations" })
  ] }) });
}

export { ExemplarsSettings };
//# sourceMappingURL=ExemplarsSettings.mjs.map
