import { jsx } from 'react/jsx-runtime';
import { useRef } from 'react';
import { useTheme2 } from '../../themes/ThemeContext.mjs';
import { AsyncSelect, Select } from '../Select/Select.mjs';

function SegmentSelect({
  value,
  placeholder = "",
  options = [],
  onChange,
  onClickOutside,
  loadOptions = undefined,
  width: widthPixels,
  noOptionsMessage = "",
  allowCustomValue = false,
  allowEmptyValue = false,
  ...rest
}) {
  const ref = useRef(null);
  const theme = useTheme2();
  let width = widthPixels > 0 ? widthPixels / theme.spacing.gridSize : undefined;
  let Component;
  let asyncOptions = {};
  if (loadOptions) {
    Component = AsyncSelect;
    asyncOptions = { loadOptions, defaultOptions: true };
  } else {
    Component = Select;
  }
  return /* @__PURE__ */ jsx("div", { ...rest, ref, children: /* @__PURE__ */ jsx(
    Component,
    {
      width,
      noOptionsMessage,
      placeholder,
      autoFocus: true,
      isOpen: true,
      onChange,
      options,
      value,
      closeMenuOnSelect: false,
      onCloseMenu: () => {
        if (ref && ref.current) {
          const input = ref.current.querySelector('input[id^="react-select-"]');
          if (input && (input.value || allowEmptyValue)) {
            onChange({ value: input.value, label: input.value });
          } else {
            onClickOutside();
          }
        }
      },
      allowCustomValue,
      ...asyncOptions
    }
  ) });
}

export { SegmentSelect };
//# sourceMappingURL=SegmentSelect.mjs.map
