import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { forwardRef } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import { getResponsiveStyle } from '../utils/responsiveness.mjs';

const Grid = forwardRef((props, ref) => {
  const { alignItems, children, gap, columns, minColumnWidth, ...rest } = props;
  const styles = useStyles2(getGridStyles, gap, columns, minColumnWidth, alignItems);
  return /* @__PURE__ */ jsx("div", { ref, ...rest, className: styles.grid, children });
});
Grid.displayName = "Grid";
const getGridStyles = (theme, gap, columns, minColumnWidth, alignItems) => {
  return {
    grid: css([
      { display: "grid" },
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      minColumnWidth && getResponsiveStyle(theme, minColumnWidth, (val) => ({
        gridTemplateColumns: `repeat(auto-fill, minmax(${theme.spacing(val)}, 1fr))`
      })),
      columns && getResponsiveStyle(theme, columns, (val) => ({
        gridTemplateColumns: `repeat(${val}, 1fr)`
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      }))
    ])
  };
};

export { Grid };
//# sourceMappingURL=Grid.mjs.map
