import { jsx } from 'react/jsx-runtime';
import { PureComponent, createRef } from 'react';

class ClickOutsideWrapper extends PureComponent {
  constructor() {
    super(...arguments);
    this.myRef = createRef();
    this.state = {
      hasEventListener: false
    };
    this.onOutsideClick = (event) => {
      const domNode = this.myRef.current;
      if (!domNode || event.target instanceof Node && !domNode.contains(event.target)) {
        this.props.onClick();
      }
    };
  }
  componentDidMount() {
    this.props.parent.addEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.addEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  componentWillUnmount() {
    this.props.parent.removeEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.removeEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  render() {
    return /* @__PURE__ */ jsx("div", { ref: this.myRef, children: this.props.children });
  }
}
ClickOutsideWrapper.defaultProps = {
  includeButtonPress: true,
  parent: typeof window !== "undefined" ? window : undefined,
  useCapture: false
};

export { ClickOutsideWrapper };
//# sourceMappingURL=ClickOutsideWrapper.mjs.map
