'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsxRuntime = require('react/jsx-runtime');
var css = require('@emotion/css');

const fadeIn = css.keyframes({
  "0%": {
    opacity: 0
  },
  "100%": {
    opacity: 1
  }
});
const skeletonAnimation = {
  animationName: fadeIn,
  animationDelay: "100ms",
  animationTimingFunction: "ease-in",
  animationDuration: "100ms",
  animationFillMode: "backwards"
};
const attachSkeleton = (Component, Skeleton) => {
  const skeletonWrapper = (props) => {
    return /* @__PURE__ */ jsxRuntime.jsx(
      Skeleton,
      {
        ...props,
        rootProps: {
          style: skeletonAnimation
        }
      }
    );
  };
  return Object.assign(Component, { Skeleton: skeletonWrapper });
};

exports.attachSkeleton = attachSkeleton;
exports.skeletonAnimation = skeletonAnimation;
//# sourceMappingURL=unstable.cjs.map
