import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { renderMarkdown } from '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.mjs';

const getStyles = (theme, height, visible) => {
  return {
    typeaheadItem: css({
      label: "type-ahead-item",
      zIndex: 11,
      padding: theme.spacing(1, 1, 1, 2),
      border: theme.colors.border.medium,
      overflowY: "scroll",
      overflowX: "hidden",
      outline: "none",
      background: theme.colors.background.secondary,
      color: theme.colors.text.secondary,
      boxShadow: `0 0 20px ${theme.v1.colors.dropdownShadow}`,
      visibility: visible === true ? "visible" : "hidden",
      width: "250px",
      minHeight: `${height + parseInt(theme.spacing(0.25), 10)}px`,
      position: "relative",
      wordBreak: "break-word"
    })
  };
};
const TypeaheadInfo = ({ item, height }) => {
  const visible = item && !!item.documentation;
  const label = item ? item.label : "";
  const documentation = renderMarkdown(item == null ? undefined : item.documentation);
  const theme = useTheme2();
  const styles = getStyles(theme, height, visible);
  return /* @__PURE__ */ jsxs("div", { className: cx([styles.typeaheadItem]), children: [
    /* @__PURE__ */ jsx("b", { children: label }),
    /* @__PURE__ */ jsx("hr", {}),
    /* @__PURE__ */ jsx("div", { dangerouslySetInnerHTML: { __html: documentation } })
  ] });
};

export { TypeaheadInfo };
//# sourceMappingURL=TypeaheadInfo.mjs.map
