import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo, useState } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { EditorRow } from '@grafana/plugin-ui';
import { promqlGrammar } from '../../promql.mjs';
import { promQueryModeller } from '../PromQueryModeller.mjs';
import { buildVisualQueryFromString } from '../parsing.mjs';
import { OperationExplainedBox } from '../shared/OperationExplainedBox.mjs';
import { OperationList } from '../shared/OperationList.mjs';
import { OperationListExplained } from '../shared/OperationListExplained.mjs';
import { OperationsEditorRow } from '../shared/OperationsEditorRow.mjs';
import { QueryBuilderHints } from '../shared/QueryBuilderHints.mjs';
import { RawQuery } from '../shared/RawQuery.mjs';
import { MetricsLabelsSection } from './MetricsLabelsSection.mjs';
import { NestedQueryList } from './NestedQueryList.mjs';
import { EXPLAIN_LABEL_FILTER_CONTENT } from './PromQueryBuilderExplained.mjs';

const PromQueryBuilder = memo((props) => {
  const { datasource, query, onChange, onRunQuery, data, showExplain } = props;
  const [highlightedOp, setHighlightedOp] = useState();
  const lang = { grammar: promqlGrammar, name: "promql" };
  const initHints = datasource.getInitHints();
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(MetricsLabelsSection, { query, onChange, datasource }) }),
    initHints.length ? /* @__PURE__ */ jsx(
      "div",
      {
        className: css({
          flexBasis: "100%"
        }),
        children: /* @__PURE__ */ jsxs("div", { className: "text-warning", children: [
          initHints[0].label,
          " ",
          initHints[0].fix ? /* @__PURE__ */ jsx("button", { type: "button", className: "text-warning", children: initHints[0].fix.label }) : null
        ] })
      }
    ) : null,
    showExplain && /* @__PURE__ */ jsx(
      OperationExplainedBox,
      {
        stepNumber: 1,
        title: /* @__PURE__ */ jsx(RawQuery, { query: `${promQueryModeller.renderQuery(query)}`, lang }),
        children: EXPLAIN_LABEL_FILTER_CONTENT
      }
    ),
    /* @__PURE__ */ jsxs(OperationsEditorRow, { children: [
      /* @__PURE__ */ jsx(
        OperationList,
        {
          queryModeller: promQueryModeller,
          datasource,
          query,
          onChange,
          onRunQuery,
          highlightedOp
        }
      ),
      /* @__PURE__ */ jsx("div", { "data-testid": selectors.components.DataSource.Prometheus.queryEditor.builder.hints, children: /* @__PURE__ */ jsx(
        QueryBuilderHints,
        {
          datasource,
          query,
          onChange,
          data,
          queryModeller: promQueryModeller,
          buildVisualQueryFromString
        }
      ) })
    ] }),
    showExplain && /* @__PURE__ */ jsx(
      OperationListExplained,
      {
        lang,
        query,
        stepNumber: 2,
        queryModeller: promQueryModeller,
        onMouseEnter: (op) => setHighlightedOp(op),
        onMouseLeave: () => setHighlightedOp(undefined)
      }
    ),
    query.binaryQueries && query.binaryQueries.length > 0 && /* @__PURE__ */ jsx(
      NestedQueryList,
      {
        query,
        datasource,
        onChange,
        onRunQuery,
        showExplain
      }
    )
  ] });
});
PromQueryBuilder.displayName = "PromQueryBuilder";

export { PromQueryBuilder };
//# sourceMappingURL=PromQueryBuilder.mjs.map
