import { jsxs, jsx } from 'react/jsx-runtime';
import { identityOverrideProcessor, FieldType } from '@grafana/data';
import { StackingMode } from '@grafana/schema';
import { RadioButtonGroup } from '../../components/Forms/RadioButtonGroup/RadioButtonGroup.mjs';
import { IconButton } from '../../components/IconButton/IconButton.mjs';
import { Input } from '../../components/Input/Input.mjs';
import { Stack } from '../../components/Layout/Stack/Stack.mjs';
import { graphFieldOptions } from '../../components/uPlot/config.mjs';

const StackingEditor = ({
  value,
  context,
  onChange,
  item
}) => {
  var _a, _b;
  return /* @__PURE__ */ jsxs(Stack, { children: [
    /* @__PURE__ */ jsx(
      RadioButtonGroup,
      {
        value: (value == null ? undefined : value.mode) || StackingMode.None,
        options: (_b = (_a = item.settings) == null ? undefined : _a.options) != null ? _b : [],
        onChange: (v) => {
          onChange({
            ...value,
            mode: v
          });
        }
      }
    ),
    context.isOverride && (value == null ? undefined : value.mode) && (value == null ? undefined : value.mode) !== StackingMode.None && /* @__PURE__ */ jsx(
      Input,
      {
        type: "text",
        placeholder: "Group",
        suffix: /* @__PURE__ */ jsx(IconButton, { name: "question-circle", tooltip: "Name of the stacking group", tooltipPlacement: "top" }),
        defaultValue: value == null ? undefined : value.group,
        onChange: (v) => {
          onChange({
            ...value,
            group: v.currentTarget.value.trim()
          });
        }
      }
    )
  ] });
};
function addStackingConfig(builder, defaultConfig, category = ["Graph styles"]) {
  builder.addCustomEditor({
    id: "stacking",
    path: "stacking",
    name: "Stack series",
    category,
    defaultValue: defaultConfig,
    editor: StackingEditor,
    override: StackingEditor,
    settings: {
      options: graphFieldOptions.stacking
    },
    process: identityOverrideProcessor,
    shouldApply: (f) => f.type === FieldType.number
  });
}

export { StackingEditor, addStackingConfig };
//# sourceMappingURL=stacking.mjs.map
