import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { ActionButton } from '../Actions/ActionButton.mjs';

const ActionsCell = (props) => {
  const { cellProps, tableStyles, actions } = props;
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: cx(tableStyles.cellContainerText, styles.buttonsGap), children: actions && actions.map((action, i) => /* @__PURE__ */ jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles = (theme) => ({
  buttonsGap: css({
    gap: 6
  })
});

export { ActionsCell };
//# sourceMappingURL=ActionsCell.mjs.map
