import { jsx } from 'react/jsx-runtime';
import { SelectBase } from './SelectBase.mjs';
import '@emotion/css';
import 'react-select';
import 'hoist-non-react-statics';
import 'micro-memoize';
import 'react';
import '@grafana/data';
import 'tinycolor2';
import '../Input/Input.mjs';

function Select(props) {
  return /* @__PURE__ */ jsx(SelectBase, { ...props });
}
function MultiSelect(props) {
  return /* @__PURE__ */ jsx(SelectBase, { ...props, isMulti: true });
}
function AsyncSelect(props) {
  return /* @__PURE__ */ jsx(SelectBase, { ...props });
}
function VirtualizedSelect(props) {
  return /* @__PURE__ */ jsx(SelectBase, { virtualized: true, ...props });
}
function AsyncVirtualizedSelect(props) {
  return /* @__PURE__ */ jsx(SelectBase, { virtualized: true, ...props });
}
function AsyncMultiSelect(props) {
  return /* @__PURE__ */ jsx(SelectBase, { ...props, isMulti: true });
}

export { AsyncMultiSelect, AsyncSelect, AsyncVirtualizedSelect, MultiSelect, Select, VirtualizedSelect };
//# sourceMappingURL=Select.mjs.map
