import { jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { PureComponent } from 'react';
import '@grafana/data';
import 'hoist-non-react-statics';
import 'micro-memoize';
import { stylesFactory } from '../../themes/stylesFactory.mjs';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';

const getStyles = stylesFactory((inlineList = false) => ({
  list: css({
    listStyleType: "none",
    margin: 0,
    padding: 0
  }),
  item: css({
    display: inlineList && "inline-block" || "block"
  })
}));
class AbstractList extends PureComponent {
  constructor(props) {
    super(props);
  }
  render() {
    const { items, renderItem, getItemKey, className, inline } = this.props;
    const styles = getStyles(inline);
    return /* @__PURE__ */ jsx("ul", { className: cx(styles.list, className), children: items.map((item, i) => {
      return /* @__PURE__ */ jsx("li", { className: styles.item, children: renderItem(item, i) }, getItemKey ? getItemKey(item) : i);
    }) });
  }
}

export { AbstractList };
//# sourceMappingURL=AbstractList.mjs.map
