import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';

const InlineFieldRow = ({ children, className, ...htmlProps }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: cx(styles.container, className), ...htmlProps, children });
};
const getStyles = (theme) => {
  return {
    container: css({
      label: "InlineFieldRow",
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      alignContent: "flex-start",
      rowGap: theme.spacing(0.5)
    })
  };
};

export { InlineFieldRow };
//# sourceMappingURL=InlineFieldRow.mjs.map
