import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { Legend } from './Legend.mjs';

const FieldSet = ({ label, children, className, ...rest }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("fieldset", { className: cx(styles.wrapper, className), ...rest, children: [
    label && /* @__PURE__ */ jsx(Legend, { children: label }),
    children
  ] });
};
const getStyles = (theme) => ({
  wrapper: css({
    marginBottom: theme.spacing(4),
    "&:last-child": {
      marginBottom: 0
    }
  })
});

export { FieldSet };
//# sourceMappingURL=FieldSet.mjs.map
