import { lowerCase } from 'lodash';
import moment from 'moment-timezone';
import { getTimeZone } from './common.mjs';
import { isValid, parse } from './datemath.mjs';
import { systemDateFormats } from './formats.mjs';
import { isDateTime, dateTime, dateTimeForTimeZone, toUtc } from './moment_wrapper.mjs';

const dateTimeParse = (value, options) => {
  if (isDateTime(value)) {
    return value;
  }
  if (typeof value === "string") {
    return parseString(value, options);
  }
  return parseOthers(value, options);
};
const parseString = (value, options) => {
  var _a;
  if (value.indexOf("now") !== -1) {
    if (!isValid(value)) {
      return dateTime();
    }
    const parsed = parse(value, options == null ? undefined : options.roundUp, options == null ? undefined : options.timeZone, options == null ? undefined : options.fiscalYearStartMonth);
    return parsed || dateTime();
  }
  let timeZone = getTimeZone(options);
  let format = (_a = options == null ? undefined : options.format) != null ? _a : systemDateFormats.fullDate;
  if (value.endsWith("Z")) {
    format = "YYYY-MM-DDTHH:mm:ss.SSSZ";
    timeZone = "utc";
  }
  const zone = moment.tz.zone(timeZone);
  if (zone && zone.name) {
    return dateTimeForTimeZone(zone.name, value, format);
  }
  switch (lowerCase(timeZone)) {
    case "utc":
      return toUtc(value, format);
    default:
      return dateTime(value, format);
  }
};
const parseOthers = (value, options) => {
  const date = value;
  const timeZone = getTimeZone(options);
  const zone = moment.tz.zone(timeZone);
  if (zone && zone.name) {
    return dateTimeForTimeZone(zone.name, date);
  }
  switch (lowerCase(timeZone)) {
    case "utc":
      return toUtc(date);
    default:
      return dateTime(date);
  }
};

export { dateTimeParse };
//# sourceMappingURL=parser.mjs.map
