import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { createElement } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { getFieldTypeIcon } from '../../types/icon.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { Filter } from './Filter.mjs';

const HeaderRow = (props) => {
  const { headerGroups, showTypeIcons, tableStyles } = props;
  const e2eSelectorsTable = selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ jsx("div", { role: "rowgroup", className: tableStyles.headerRow, children: headerGroups.map((headerGroup) => {
    const { key, ...headerGroupProps } = headerGroup.getHeaderGroupProps();
    return /* @__PURE__ */ createElement(
      "div",
      {
        className: tableStyles.thead,
        ...headerGroupProps,
        key,
        "aria-label": e2eSelectorsTable.header,
        role: "row"
      },
      headerGroup.headers.map(
        (column, index) => renderHeaderCell(column, tableStyles, showTypeIcons)
      )
    );
  }) });
};
function renderHeaderCell(column, tableStyles, showTypeIcons) {
  var _a;
  const { key, ...headerProps } = column.getHeaderProps();
  const field = (_a = column.field) != null ? _a : null;
  const tableFieldOptions = field == null ? undefined : field.config.custom;
  if (column.canResize) {
    headerProps.style.userSelect = column.isResizing ? "none" : "auto";
  }
  headerProps.style.position = "absolute";
  headerProps.style.justifyContent = column.justifyContent;
  headerProps.style.left = column.totalLeft;
  let headerContent = column.render("Header");
  let sortHeaderContent = column.canSort && /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs("button", { ...column.getSortByToggleProps(), className: tableStyles.headerCellLabel, children: [
      showTypeIcons && /* @__PURE__ */ jsx(Icon, { name: getFieldTypeIcon(field), title: field == null ? undefined : field.type, size: "sm", className: tableStyles.typeIcon }),
      /* @__PURE__ */ jsx("div", { children: headerContent }),
      column.isSorted && (column.isSortedDesc ? /* @__PURE__ */ jsx(Icon, { size: "lg", name: "arrow-down", className: tableStyles.sortIcon }) : /* @__PURE__ */ jsx(Icon, { name: "arrow-up", size: "lg", className: tableStyles.sortIcon }))
    ] }),
    column.canFilter && /* @__PURE__ */ jsx(Filter, { column, tableStyles, field })
  ] });
  if (sortHeaderContent && (tableFieldOptions == null ? undefined : tableFieldOptions.headerComponent)) {
    sortHeaderContent = /* @__PURE__ */ jsx(tableFieldOptions.headerComponent, { field, defaultContent: sortHeaderContent });
  } else if (tableFieldOptions == null ? undefined : tableFieldOptions.headerComponent) {
    headerContent = /* @__PURE__ */ jsx(tableFieldOptions.headerComponent, { field, defaultContent: headerContent });
  }
  return /* @__PURE__ */ jsxs("div", { className: tableStyles.headerCell, ...headerProps, role: "columnheader", children: [
    column.canSort && sortHeaderContent,
    !column.canSort && headerContent,
    !column.canSort && column.canFilter && /* @__PURE__ */ jsx(Filter, { column, tableStyles, field }),
    column.canResize && /* @__PURE__ */ jsx("div", { ...column.getResizerProps(), className: tableStyles.resizeHandle })
  ] }, key);
}

export { HeaderRow };
//# sourceMappingURL=HeaderRow.mjs.map
