import { FieldType, isLikelyAscendingVector, sortDataFrame, applyNullInsertThreshold } from '@grafana/data';

function preparePlotFrame(sparkline, config) {
  var _a, _b, _c;
  const length = sparkline.y.values.length;
  const yFieldConfig = {
    ...sparkline.y.config,
    ...config
  };
  const xField = (_a = sparkline.x) != null ? _a : {
    name: "",
    values: [...Array(length).keys()],
    type: FieldType.number,
    config: {}
  };
  let frame = {
    refId: "sparkline",
    fields: [
      xField,
      {
        ...sparkline.y,
        config: yFieldConfig
      }
    ],
    length
  };
  if (!isLikelyAscendingVector(xField.values)) {
    frame = sortDataFrame(frame, 0);
  }
  return applyNullInsertThreshold({
    frame,
    refFieldPseudoMin: (_b = sparkline.timeRange) == null ? undefined : _b.from.valueOf(),
    refFieldPseudoMax: (_c = sparkline.timeRange) == null ? undefined : _c.to.valueOf()
  });
}

export { preparePlotFrame };
//# sourceMappingURL=utils.mjs.map
