import { jsx } from 'react/jsx-runtime';
import { useRef } from 'react';
import { MonacoQueryFieldLazy } from './MonacoQueryFieldLazy.mjs';

const MonacoQueryFieldWrapper = (props) => {
  const lastRunValueRef = useRef(null);
  const { onRunQuery, onChange, ...rest } = props;
  const handleRunQuery = (value) => {
    lastRunValueRef.current = value;
    onChange(value);
    onRunQuery();
  };
  const handleBlur = (value) => {
    onChange(value);
  };
  return /* @__PURE__ */ jsx(MonacoQueryFieldLazy, { onRunQuery: handleRunQuery, onBlur: handleBlur, ...rest });
};

export { MonacoQueryFieldWrapper };
//# sourceMappingURL=MonacoQueryFieldWrapper.mjs.map
