import { jsxs, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import { Global } from '@emotion/react';
import SliderComponent from 'rc-slider';
import { useCallback } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import HandleTooltip from './HandleTooltip.mjs';
import { getStyles } from './styles.mjs';

const RangeSlider = ({
  min,
  max,
  onChange,
  onAfterChange,
  orientation = "horizontal",
  reverse,
  step,
  formatTooltipResult,
  value,
  tooltipAlwaysVisible = true
}) => {
  const handleChange = useCallback(
    (v) => {
      const value2 = typeof v === "number" ? [v, v] : v;
      onChange == null ? undefined : onChange(value2);
    },
    [onChange]
  );
  const handleChangeComplete = useCallback(
    (v) => {
      const value2 = typeof v === "number" ? [v, v] : v;
      onAfterChange == null ? undefined : onAfterChange(value2);
    },
    [onAfterChange]
  );
  const isHorizontal = orientation === "horizontal";
  const styles = useStyles2(getStyles, isHorizontal);
  const tipHandleRender = (node, handleProps) => {
    return /* @__PURE__ */ jsx(
      HandleTooltip,
      {
        value: handleProps.value,
        visible: tooltipAlwaysVisible || handleProps.dragging,
        tipFormatter: formatTooltipResult ? () => formatTooltipResult(handleProps.value) : undefined,
        placement: isHorizontal ? "top" : "right",
        children: node
      }
    );
  };
  return /* @__PURE__ */ jsxs("div", { className: cx(styles.container, styles.slider), children: [
    /* @__PURE__ */ jsx(Global, { styles: styles.tooltip }),
    /* @__PURE__ */ jsx(
      SliderComponent,
      {
        min,
        max,
        step,
        defaultValue: value,
        range: true,
        onChange: handleChange,
        onChangeComplete: handleChangeComplete,
        vertical: !isHorizontal,
        reverse,
        handleRender: tipHandleRender
      }
    )
  ] });
};
RangeSlider.displayName = "RangeSlider";

export { RangeSlider };
//# sourceMappingURL=RangeSlider.mjs.map
