import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { InlineField } from '../Forms/InlineField.mjs';
import { t } from '../../utils/i18n.mjs';
import { FormField } from '../FormField/FormField.mjs';
import { SecretFormField } from '../SecretFormField/SecretFormField.mjs';

const BasicAuthSettings = ({ dataSourceConfig, onChange }) => {
  const password = dataSourceConfig.secureJsonData ? dataSourceConfig.secureJsonData.basicAuthPassword : "";
  const onPasswordReset = () => {
    onChange({
      ...dataSourceConfig,
      secureJsonData: {
        ...dataSourceConfig.secureJsonData,
        basicAuthPassword: ""
      },
      secureJsonFields: {
        ...dataSourceConfig.secureJsonFields,
        basicAuthPassword: false
      }
    });
  };
  const onPasswordChange = (event) => {
    onChange({
      ...dataSourceConfig,
      secureJsonData: {
        ...dataSourceConfig.secureJsonData,
        basicAuthPassword: event.currentTarget.value
      }
    });
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(InlineField, { disabled: dataSourceConfig.readOnly, children: /* @__PURE__ */ jsx(
      FormField,
      {
        label: t("grafana-ui.data-source-basic-auth-settings.user-label", "User"),
        labelWidth: 10,
        inputWidth: 18,
        placeholder: t("grafana-ui.data-source-basic-auth-settings.user-placeholder", "user"),
        value: dataSourceConfig.basicAuthUser,
        onChange: (event) => onChange({ ...dataSourceConfig, basicAuthUser: event.currentTarget.value })
      }
    ) }),
    /* @__PURE__ */ jsx(InlineField, { disabled: dataSourceConfig.readOnly, children: /* @__PURE__ */ jsx(
      SecretFormField,
      {
        isConfigured: !!(dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.basicAuthPassword),
        value: password || "",
        inputWidth: 18,
        labelWidth: 10,
        onReset: onPasswordReset,
        onChange: onPasswordChange
      }
    ) })
  ] });
};

export { BasicAuthSettings };
//# sourceMappingURL=BasicAuthSettings.mjs.map
