import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { t, Trans } from '../../utils/i18n.mjs';
import { Field } from '../Forms/Field.mjs';
import { Input } from '../Input/Input.mjs';
import { Switch } from '../Switch/Switch.mjs';
import { DataLinkInput } from './DataLinkInput.mjs';

const getStyles = (theme) => ({
  listItem: css({
    marginBottom: theme.spacing()
  }),
  infoText: css({
    paddingBottom: theme.spacing(2),
    marginLeft: "66px",
    color: theme.colors.text.secondary
  })
});
const DataLinkEditor = memo(
  ({ index, value, onChange, suggestions, isLast, showOneClick = false }) => {
    const styles = useStyles2(getStyles);
    const onUrlChange = (url, callback) => {
      onChange(index, { ...value, url }, callback);
    };
    const onTitleChange = (event) => {
      onChange(index, { ...value, title: event.target.value });
    };
    const onOpenInNewTabChanged = () => {
      onChange(index, { ...value, targetBlank: !value.targetBlank });
    };
    const onOneClickChanged = () => {
      onChange(index, { ...value, oneClick: !value.oneClick });
    };
    return /* @__PURE__ */ jsxs("div", { className: styles.listItem, children: [
      /* @__PURE__ */ jsx(Field, { label: t("grafana-ui.data-link-editor.title-label", "Title"), children: /* @__PURE__ */ jsx(
        Input,
        {
          value: value.title,
          onChange: onTitleChange,
          placeholder: t("grafana-ui.data-link-editor.title-placeholder", "Show details")
        }
      ) }),
      /* @__PURE__ */ jsx(Field, { label: t("grafana-ui.data-link-editor.url-label", "URL"), children: /* @__PURE__ */ jsx(DataLinkInput, { value: value.url, onChange: onUrlChange, suggestions }) }),
      /* @__PURE__ */ jsx(Field, { label: t("grafana-ui.data-link-editor.new-tab-label", "Open in new tab"), children: /* @__PURE__ */ jsx(Switch, { value: value.targetBlank || false, onChange: onOpenInNewTabChanged }) }),
      showOneClick && /* @__PURE__ */ jsx(
        Field,
        {
          label: t("grafana-ui.data-link-inline-editor.one-click", "One click"),
          description: t(
            "grafana-ui.data-link-editor-modal.one-click-description",
            "Only one link can have one click enabled at a time"
          ),
          children: /* @__PURE__ */ jsx(Switch, { value: value.oneClick || false, onChange: onOneClickChanged })
        }
      ),
      isLast && /* @__PURE__ */ jsx("div", { className: styles.infoText, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.data-link-editor.info", children: "With data links you can reference data variables like series name, labels and values. Type CMD+Space, CTRL+Space, or $ to open variable suggestions." }) })
    ] });
  }
);
DataLinkEditor.displayName = "DataLinkEditor";

export { DataLinkEditor };
//# sourceMappingURL=DataLinkEditor.mjs.map
