import { jsx, jsxs } from 'react/jsx-runtime';
import { offset, flip, shift, arrow, useFloating, autoUpdate, useTransitionStyles, FloatingArrow } from '@floating-ui/react';
import * as React from 'react';
import { useRef, useLayoutEffect } from 'react';
import '@grafana/data';
import { useTheme2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { getPlacement } from '../../utils/tooltipUtils.mjs';
import { Portal } from '../Portal/Portal.mjs';

function Popover({
  content,
  show,
  placement,
  className,
  wrapperClassName,
  referenceElement,
  renderArrow,
  hidePopper,
  ...rest
}) {
  const theme = useTheme2();
  const arrowRef = useRef(null);
  const middleware = [
    offset(8),
    flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    shift()
  ];
  if (renderArrow) {
    middleware.push(
      arrow({
        element: arrowRef
      })
    );
  }
  const { context, refs, floatingStyles } = useFloating({
    open: show,
    placement: getPlacement(placement),
    middleware,
    whileElementsMounted: autoUpdate,
    strategy: "fixed"
  });
  useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = useTransitionStyles(context, {
    initial: () => ({
      opacity: 0
    }),
    duration: theme.transitions.duration.enteringScreen
  });
  return show ? /* @__PURE__ */ jsx(Portal, { children: /* @__PURE__ */ jsx(
    "div",
    {
      ref: refs.setFloating,
      style: {
        ...floatingStyles,
        ...placementStyles
      },
      className: wrapperClassName,
      ...rest,
      children: /* @__PURE__ */ jsxs("div", { className, children: [
        renderArrow && /* @__PURE__ */ jsx(FloatingArrow, { fill: theme.colors.border.weak, ref: arrowRef, context }),
        typeof content === "string" && content,
        React.isValidElement(content) && React.cloneElement(content),
        typeof content === "function" && content({ hidePopper })
      ] })
    }
  ) }) : undefined;
}

export { Popover };
//# sourceMappingURL=Popover.mjs.map
