import { FieldConfigOptionsRegistry } from '../field/FieldConfigOptionsRegistry.mjs';
import { standardFieldConfigEditorRegistry } from '../field/standardFieldConfigEditorRegistry.mjs';
import { FieldConfigEditorBuilder } from '../utils/OptionsUIBuilders.mjs';

function createFieldConfigRegistry(config = {}, pluginName) {
  var _a, _b, _c, _d;
  const registry = new FieldConfigOptionsRegistry();
  const standardConfigs = standardFieldConfigEditorRegistry.list();
  const standardOptionsExtensions = {};
  if (config.useCustomConfig) {
    const builder = new FieldConfigEditorBuilder();
    config.useCustomConfig(builder);
    for (const customProp of builder.getRegistry().list()) {
      customProp.isCustom = true;
      customProp.id = "custom." + customProp.id;
      if (isStandardConfigExtension(customProp, standardConfigs)) {
        const currentExtensions = (_a = standardOptionsExtensions[customProp.category[0]]) != null ? _a : [];
        currentExtensions.push(customProp);
        standardOptionsExtensions[customProp.category[0]] = currentExtensions;
      } else {
        registry.register(customProp);
      }
    }
  }
  for (let fieldConfigProp of standardConfigs) {
    const id = fieldConfigProp.id;
    if (config.disableStandardOptions) {
      const isDisabled = config.disableStandardOptions.indexOf(id) > -1;
      if (isDisabled) {
        continue;
      }
    }
    if (config.standardOptions) {
      const customHideFromDefaults = (_b = config.standardOptions[id]) == null ? undefined : _b.hideFromDefaults;
      const customDefault = (_c = config.standardOptions[id]) == null ? undefined : _c.defaultValue;
      const customSettings = (_d = config.standardOptions[id]) == null ? undefined : _d.settings;
      if (customHideFromDefaults !== undefined) {
        fieldConfigProp = {
          ...fieldConfigProp,
          hideFromDefaults: customHideFromDefaults
        };
      }
      if (customDefault) {
        fieldConfigProp = {
          ...fieldConfigProp,
          defaultValue: customDefault
        };
      }
      if (customSettings) {
        fieldConfigProp = {
          ...fieldConfigProp,
          settings: fieldConfigProp.settings ? { ...fieldConfigProp.settings, ...customSettings } : customSettings
        };
      }
    }
    registry.register(fieldConfigProp);
    if (fieldConfigProp.category && standardOptionsExtensions[fieldConfigProp.category[0]]) {
      for (let extensionProperty of standardOptionsExtensions[fieldConfigProp.category[0]]) {
        registry.register(extensionProperty);
      }
    }
  }
  for (const item of registry.list()) {
    if (item.path.indexOf("[") > 0) {
      throw new Error(`[${pluginName}] Field config paths do not support arrays: ${item.id}`);
    }
  }
  return registry;
}
function isStandardConfigExtension(property, standardProperties) {
  return Boolean(
    standardProperties.find((p) => property.category && p.category && property.category[0] === p.category[0])
  );
}

export { createFieldConfigRegistry };
//# sourceMappingURL=registryFactories.mjs.map
