import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';

const FooterCell = (props) => {
  const cell = css({
    width: "100%",
    listStyle: "none"
  });
  const list = css({
    width: "100%",
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between"
  });
  if (props.value && !Array.isArray(props.value)) {
    return /* @__PURE__ */ jsx("span", { children: props.value });
  }
  if (props.value && Array.isArray(props.value) && props.value.length > 0) {
    return /* @__PURE__ */ jsx("ul", { className: cell, children: props.value.map((v, i) => {
      const key = Object.keys(v)[0];
      return /* @__PURE__ */ jsxs("li", { className: list, children: [
        /* @__PURE__ */ jsx("span", { children: key }),
        /* @__PURE__ */ jsx("span", { children: v[key] })
      ] }, i);
    }) });
  }
  return EmptyCell;
};
const EmptyCell = () => {
  return /* @__PURE__ */ jsx("span", { children: "\xA0" });
};

export { EmptyCell, FooterCell };
//# sourceMappingURL=FooterCell.mjs.map
