import { jsxs, jsx } from 'react/jsx-runtime';
import { cx } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { getComboboxStyles } from './getComboboxStyles.mjs';

const OptionListItem = ({ label, description, id, isGroup = false }) => {
  const styles = useStyles2(getComboboxStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.optionBody, "aria-disabled": isGroup, children: [
    /* @__PURE__ */ jsx("span", { className: cx(styles.optionLabel, { [styles.optionLabelGroup]: isGroup }), id, children: label }),
    description && /* @__PURE__ */ jsx("span", { className: styles.optionDescription, children: description })
  ] });
};

export { OptionListItem };
//# sourceMappingURL=OptionListItem.mjs.map
