import { Registry } from '../utils/Registry.mjs';
import { getFieldTypeMatchers } from './matchers/fieldTypeMatcher.mjs';
import { fieldValueMatcherInfo } from './matchers/fieldValueMatcher.mjs';
import { getFieldNameMatchers, getFrameNameMatchers } from './matchers/nameMatcher.mjs';
import { getFieldPredicateMatchers, getFramePredicateMatchers } from './matchers/predicates.mjs';
import { getRefIdMatchers } from './matchers/refIdMatcher.mjs';
import { getSimpleFieldMatchers } from './matchers/simpleFieldMatcher.mjs';
import { getEqualValueMatchers } from './matchers/valueMatchers/equalMatchers.mjs';
import { getNullValueMatchers } from './matchers/valueMatchers/nullMatchers.mjs';
import { getNumericValueMatchers } from './matchers/valueMatchers/numericMatchers.mjs';
import { getRangeValueMatchers } from './matchers/valueMatchers/rangeMatchers.mjs';
import { getRegexValueMatcher } from './matchers/valueMatchers/regexMatchers.mjs';
import { getSubstringValueMatchers } from './matchers/valueMatchers/substringMatchers.mjs';

const fieldMatchers = new Registry(() => {
  return [
    ...getFieldPredicateMatchers(),
    // Predicates
    ...getFieldTypeMatchers(),
    // by type
    ...getFieldNameMatchers(),
    // by name
    ...getSimpleFieldMatchers(),
    // first
    fieldValueMatcherInfo
    // reduce field (all null/zero)
  ];
});
const frameMatchers = new Registry(() => {
  return [
    ...getFramePredicateMatchers(),
    // Predicates
    ...getFrameNameMatchers(),
    // by name
    ...getRefIdMatchers()
    // by query refId
  ];
});
const valueMatchers = new Registry(() => {
  return [
    ...getNullValueMatchers(),
    ...getNumericValueMatchers(),
    ...getEqualValueMatchers(),
    ...getSubstringValueMatchers(),
    ...getRangeValueMatchers(),
    ...getRegexValueMatcher()
  ];
});
function getFieldMatcher(config) {
  const info = fieldMatchers.get(config.id);
  if (!info) {
    throw new Error("Unknown field matcher: " + config.id);
  }
  return info.get(config.options);
}
function getFrameMatchers(config) {
  const info = frameMatchers.get(config.id);
  if (!info) {
    throw new Error("Unknown frame matcher: " + config.id);
  }
  return info.get(config.options);
}
function getValueMatcher(config) {
  const info = valueMatchers.get(config.id);
  if (!info) {
    throw new Error("Unknown value matcher: " + config.id);
  }
  return info.get(config.options);
}

export { fieldMatchers, frameMatchers, getFieldMatcher, getFrameMatchers, getValueMatcher, valueMatchers };
//# sourceMappingURL=matchers.mjs.map
