import { isEqual, difference } from 'lodash';
import { Component } from 'react';

class GraphSeriesToggler extends Component {
  constructor(props) {
    super(props);
    this.onSeriesToggle = this.onSeriesToggle.bind(this);
    this.state = {
      hiddenSeries: [],
      toggledSeries: props.series
    };
  }
  componentDidUpdate(prevProps) {
    const { series } = this.props;
    if (!isEqual(prevProps.series, series)) {
      this.setState({ hiddenSeries: [], toggledSeries: series });
    }
  }
  onSeriesToggle(label, event) {
    const { series, onHiddenSeriesChanged } = this.props;
    const { hiddenSeries } = this.state;
    if (event.ctrlKey || event.metaKey || event.shiftKey) {
      const newHiddenSeries2 = hiddenSeries.indexOf(label) > -1 ? hiddenSeries.filter((series2) => series2 !== label) : hiddenSeries.concat([label]);
      const toggledSeries2 = series.map((series2) => ({
        ...series2,
        isVisible: newHiddenSeries2.indexOf(series2.label) === -1
      }));
      this.setState(
        { hiddenSeries: newHiddenSeries2, toggledSeries: toggledSeries2 },
        () => onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries2) : undefined
      );
      return;
    }
    const allSeriesLabels = series.map((series2) => series2.label);
    const newHiddenSeries = hiddenSeries.length + 1 === allSeriesLabels.length ? [] : difference(allSeriesLabels, [label]);
    const toggledSeries = series.map((series2) => ({
      ...series2,
      isVisible: newHiddenSeries.indexOf(series2.label) === -1
    }));
    this.setState(
      { hiddenSeries: newHiddenSeries, toggledSeries },
      () => onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries) : undefined
    );
  }
  render() {
    const { children } = this.props;
    const { toggledSeries } = this.state;
    return children({
      onSeriesToggle: this.onSeriesToggle,
      toggledSeries
    });
  }
}

export { GraphSeriesToggler };
//# sourceMappingURL=GraphSeriesToggler.mjs.map
