import { map } from 'rxjs/operators';
import { fieldMatchers } from '../matchers.mjs';
import { FieldMatcherID } from '../matchers/ids.mjs';
import { DataTransformerID } from './ids.mjs';
import { joinDataFrames } from './joinDataFrames.mjs';

var JoinMode = /* @__PURE__ */ ((JoinMode2) => {
  JoinMode2["outer"] = "outer";
  JoinMode2["inner"] = "inner";
  JoinMode2["outerTabular"] = "outerTabular";
  return JoinMode2;
})(JoinMode || {});
const joinByFieldTransformer = {
  id: DataTransformerID.joinByField,
  aliasIds: [DataTransformerID.seriesToColumns],
  name: "Join by field",
  description: "Combine rows from two or more tables, based on a related field between them.  This can be used to outer join multiple time series on the _time_ field to show many time series in one table.",
  defaultOptions: {
    byField: undefined,
    // DEFAULT_KEY_FIELD,
    mode: "outer" /* outer */
  },
  operator: (options, ctx) => (source) => source.pipe(map((data) => joinByFieldTransformer.transformer(options, ctx)(data))),
  transformer: (options, ctx) => {
    let joinBy = undefined;
    return (data) => {
      if (data.length > 1) {
        if (options.byField && !joinBy) {
          joinBy = fieldMatchers.get(FieldMatcherID.byName).get(options.byField);
        }
        const joined = joinDataFrames({ frames: data, joinBy, mode: options.mode });
        if (joined) {
          joined.refId = `${DataTransformerID.joinByField}-${data.map((frame) => frame.refId).join("-")}`;
          return [joined];
        }
      }
      return data;
    };
  }
};

export { JoinMode, joinByFieldTransformer };
//# sourceMappingURL=joinByField.mjs.map
