import { map } from 'rxjs/operators';
import { sortDataFrame } from '../../dataframe/processDataFrame.mjs';
import { getFieldDisplayName } from '../../field/fieldState.mjs';
import { DataTransformerID } from './ids.mjs';

const sortByTransformer = {
  id: DataTransformerID.sortBy,
  name: "Sort by",
  description: "Sort fields in a frame.",
  defaultOptions: {
    fields: {}
  },
  /**
   * Return a modified copy of the series. If the transform is not or should not
   * be applied, just return the input series
   */
  operator: (options, ctx) => (source) => source.pipe(
    map((data) => {
      var _a;
      if (!Array.isArray(data) || data.length === 0 || !((_a = options == null ? undefined : options.sort) == null ? undefined : _a.length)) {
        return data;
      }
      return sortDataFrames(data, options.sort);
    })
  )
};
function sortDataFrames(data, sort, ctx) {
  return data.map((frame) => {
    const s = attachFieldIndex(frame, sort);
    if (s.length && s[0].index != null) {
      return sortDataFrame(frame, s[0].index, s[0].desc);
    }
    return frame;
  });
}
function attachFieldIndex(frame, sort, ctx) {
  return sort.map((s) => {
    if (s.index != null) {
      return s;
    }
    return {
      ...s,
      index: frame.fields.findIndex((f) => s.field === getFieldDisplayName(f, frame))
    };
  });
}

export { sortByTransformer };
//# sourceMappingURL=sortBy.mjs.map
