import { createContext, useContext } from 'react';
import { useObservable } from 'react-use';
import { sidecarServiceSingleton_EXPERIMENTAL } from './SidecarService_EXPERIMENTAL.mjs';

const SidecarContext_EXPERIMENTAL = createContext(
  sidecarServiceSingleton_EXPERIMENTAL
);
function useSidecar_EXPERIMENTAL() {
  const service = useContext(SidecarContext_EXPERIMENTAL);
  if (!service) {
    throw new Error("No SidecarContext found");
  }
  const initialContext = useObservable(service.initialContextObservable, service.initialContext);
  const activePluginId = useObservable(service.activePluginIdObservable, service.activePluginId);
  const locationService = service.getLocationService();
  return {
    activePluginId,
    initialContext,
    locationService,
    // TODO: currently this allows anybody to open any app, in the future we should probably scope this to the
    //  current app but that means we will need to incorporate this better into the plugin platform APIs which
    //  we will do once the functionality is reasonably stable
    openApp: (pluginId, context) => {
      return service.openApp(pluginId, context);
    },
    openAppV2: (pluginId, path) => {
      return service.openAppV2(pluginId, path);
    },
    openAppV3: (options) => {
      return service.openAppV3(options);
    },
    closeApp: () => service.closeApp(),
    isAppOpened: (pluginId) => {
      return service.isAppOpened(pluginId);
    }
  };
}

export { SidecarContext_EXPERIMENTAL, useSidecar_EXPERIMENTAL };
//# sourceMappingURL=SidecarContext_EXPERIMENTAL.mjs.map
