import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useState } from 'react';
import { IconButton } from '../IconButton/IconButton.mjs';
import { Tab } from '../Tabs/Tab.mjs';
import { TabsBar } from '../Tabs/TabsBar.mjs';
import { TabContent } from '../Tabs/TabContent.mjs';
import '@grafana/data';
import { useStyles2, useTheme2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';
import { ScrollContainer } from '../ScrollContainer/ScrollContainer.mjs';

function TabbedContainer({ tabs, defaultTab, closeIconTooltip, onClose, testId }) {
  var _a;
  const [activeTab, setActiveTab] = useState(tabs.some((tab) => tab.value === defaultTab) ? defaultTab : tabs[0].value);
  const styles = useStyles2(getStyles);
  const theme = useTheme2();
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  const autoHeight = `calc(100% - (${theme.spacing(theme.components.menuTabs.height)} + ${theme.spacing(1)}))`;
  return /* @__PURE__ */ jsxs("div", { className: styles.container, "data-testid": testId, children: [
    /* @__PURE__ */ jsxs(TabsBar, { className: styles.tabs, children: [
      tabs.map((t) => /* @__PURE__ */ jsx(
        Tab,
        {
          label: t.label,
          active: t.value === activeTab,
          onChangeTab: () => onSelectTab(t),
          icon: t.icon
        },
        t.value
      )),
      /* @__PURE__ */ jsx(IconButton, { className: styles.close, onClick: onClose, name: "times", tooltip: closeIconTooltip != null ? closeIconTooltip : "Close" })
    ] }),
    /* @__PURE__ */ jsx(ScrollContainer, { height: autoHeight, children: /* @__PURE__ */ jsx(TabContent, { className: styles.tabContent, children: (_a = tabs.find((t) => t.value === activeTab)) == null ? undefined : _a.content }) })
  ] });
}
const getStyles = (theme) => ({
  container: css({
    height: "100%"
  }),
  tabContent: css({
    padding: theme.spacing(2),
    backgroundColor: theme.colors.background.primary,
    height: `100%`
  }),
  close: css({
    position: "absolute",
    right: "16px",
    top: "5px",
    cursor: "pointer",
    fontSize: theme.typography.size.lg
  }),
  tabs: css({
    paddingTop: theme.spacing(1),
    borderColor: theme.colors.border.weak,
    ul: {
      marginLeft: theme.spacing(2)
    }
  })
});

export { TabbedContainer };
//# sourceMappingURL=TabbedContainer.mjs.map
