import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.mjs';

const ModalTabContent = ({ children }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx("div", { className: styles.header, children: /* @__PURE__ */ jsx("div", { className: styles.content, children }) }) });
};
const getStyles = (theme) => ({
  header: css({
    display: "flex",
    margin: theme.spacing(0, 0, 3, 0)
  }),
  content: css({
    flexGrow: 1
  })
});

export { ModalTabContent };
//# sourceMappingURL=ModalTabContent.mjs.map
