const utf8Support = (value) => {
  if (value === "") {
    return value;
  }
  const isLegacyLabel = isValidLegacyName(value);
  if (isLegacyLabel) {
    return value;
  }
  return `"${value}"`;
};
const escapeForUtf8Support = (value) => {
  const isLegacyLabel = isValidLegacyName(value);
  if (isLegacyLabel) {
    return value;
  }
  let escaped = "U__";
  for (let i = 0; i < value.length; i++) {
    const char = value[i];
    const codePoint = value.codePointAt(i);
    if (char === "_") {
      escaped += "__";
    } else if (codePoint !== undefined && isValidLegacyRune(char, i)) {
      escaped += char;
    } else if (codePoint === undefined || !isValidCodePoint(codePoint)) {
      escaped += "_FFFD_";
    } else {
      escaped += "_";
      escaped += codePoint.toString(16);
      escaped += "_";
    }
    if (codePoint !== undefined && codePoint > 65535) {
      i++;
    }
  }
  return escaped;
};
const isValidLegacyName = (name) => {
  if (name.length === 0) {
    return false;
  }
  for (let i = 0; i < name.length; i++) {
    const char = name[i];
    if (!isValidLegacyRune(char, i)) {
      return false;
    }
  }
  return true;
};
const isValidLegacyRune = (char, index) => {
  const codePoint = char.codePointAt(0);
  if (codePoint === undefined) {
    return false;
  }
  return codePoint >= 97 && codePoint <= 122 || // 'a' to 'z'
  codePoint >= 65 && codePoint <= 90 || // 'A' to 'Z'
  codePoint === 95 || // '_'
  codePoint === 58 || // ':'
  codePoint >= 48 && codePoint <= 57 && index > 0;
};
const isValidCodePoint = (codePoint) => {
  return codePoint >= 0 && codePoint <= 1114111;
};
const wrapUtf8Filters = (filterStr) => {
  const resultArray = [];
  const operatorRegex = /(=~|!=|!~|=)/;
  let currentKey = "";
  let currentValue = "";
  let inQuotes = false;
  let temp = "";
  const addResult = () => {
    const operatorMatch = temp.match(operatorRegex);
    if (operatorMatch) {
      const operator = operatorMatch[0];
      [currentKey, currentValue] = temp.split(operator);
      resultArray.push(`${utf8Support(currentKey.trim())}${operator}"${currentValue.slice(1, -1)}"`);
    }
  };
  for (const char of filterStr) {
    if (char === '"' && temp[temp.length - 1] !== "\\") {
      inQuotes = !inQuotes;
      temp += char;
    } else if (char === "," && !inQuotes) {
      addResult();
      temp = "";
    } else {
      temp += char;
    }
  }
  if (temp) {
    addResult();
  }
  return resultArray.join(",");
};

export { escapeForUtf8Support, isValidLegacyName, utf8Support, wrapUtf8Filters };
//# sourceMappingURL=utf8_support.mjs.map
