const labelRegexp = /\b(\w+)(!?=~?)"([^"\n]*?)"/g;
function parseLabels(labels) {
  const labelsByKey = {};
  labels.replace(labelRegexp, (_, key, operator, value) => {
    labelsByKey[key] = value;
    return "";
  });
  return labelsByKey;
}
function findCommonLabels(labelsSets) {
  return labelsSets.reduce(
    (acc, labels) => {
      if (!labels) {
        throw new Error("Need parsed labels to find common labels.");
      }
      Object.keys(labels).forEach((key) => {
        if (acc[key] === undefined || acc[key] !== labels[key]) {
          delete acc[key];
        }
      });
      Object.keys(acc).forEach((key) => {
        if (labels[key] === undefined) {
          delete acc[key];
        }
      });
      return acc;
    },
    { ...labelsSets[0] }
  );
}
function findUniqueLabels(labels, commonLabels) {
  const uncommonLabels = { ...labels };
  Object.keys(commonLabels).forEach((key) => {
    delete uncommonLabels[key];
  });
  return uncommonLabels;
}
function matchAllLabels(expect, against) {
  if (!expect) {
    return true;
  }
  for (const [key, value] of Object.entries(expect)) {
    if (!against || against[key] !== value) {
      return false;
    }
  }
  return true;
}
function formatLabels(labels, defaultValue = "", withoutBraces) {
  if (!labels || Object.keys(labels).length === 0) {
    return defaultValue;
  }
  const labelKeys = Object.keys(labels).sort();
  const cleanSelector = labelKeys.map((key) => `${key}="${labels[key]}"`).join(", ");
  if (withoutBraces) {
    return cleanSelector;
  }
  return ["{", cleanSelector, "}"].join("");
}

export { findCommonLabels, findUniqueLabels, formatLabels, matchAllLabels, parseLabels };
//# sourceMappingURL=labels.mjs.map
