import { useCallback } from 'react';
import { getFieldDisplayName } from '@grafana/data';

function useTableStateReducer({ onColumnResize, onSortByChange, data }) {
  return useCallback(
    (newState, action) => {
      var _a, _b, _c, _d;
      switch (action.type) {
        case "columnDoneResizing":
          if (onColumnResize) {
            const info = (_b = (_a = newState.columnResizing) == null ? undefined : _a.headerIdWidths) == null ? undefined : _b[0];
            const columnIdString = info == null ? undefined : info[0];
            const fieldIndex = parseInt(columnIdString, 10);
            const width = Math.round((_c = newState.columnResizing.columnWidths) == null ? undefined : _c[columnIdString]);
            const field = (_d = data.fields) == null ? undefined : _d[fieldIndex];
            if (!field) {
              return newState;
            }
            const fieldDisplayName = getFieldDisplayName(field, data);
            onColumnResize(fieldDisplayName, width);
          }
        case "toggleSortBy":
          if (onSortByChange) {
            const sortByFields = [];
            for (const sortItem of newState.sortBy) {
              const field = data.fields[parseInt(sortItem.id, 10)];
              if (!field) {
                continue;
              }
              sortByFields.push({
                displayName: getFieldDisplayName(field, data),
                desc: sortItem.desc
              });
            }
            onSortByChange(sortByFields);
          }
        case "toggleRowExpanded": {
          if (action.id) {
            return {
              ...newState,
              lastExpandedOrCollapsedIndex: parseInt(action.id, 10)
            };
          }
        }
      }
      return newState;
    },
    [data, onColumnResize, onSortByChange]
  );
}
function getInitialState(initialSortBy, columns) {
  const state = {};
  if (initialSortBy) {
    state.sortBy = [];
    for (const sortBy of initialSortBy) {
      for (const col of columns) {
        if (col.Header === sortBy.displayName) {
          state.sortBy.push({ id: col.id, desc: sortBy.desc });
        }
      }
    }
  }
  return state;
}

export { getInitialState, useTableStateReducer };
//# sourceMappingURL=reducer.mjs.map
